<?php
session_start();
require_once('../classes/mysql.class.php');
$page = "adm";
$security = new MySQL();
$security->checkLogin();

$intakelist = new MySQL;
$intakelist->Query("SELECT * FROM intakes ORDER BY id DESC");
$icount = $intakelist->RowCount();

?>
<!DOCTYPE html>
<html lang="en" class="no-js">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
<meta charset="UTF-8"/>
<title>SMART | Create & Activate Intake Types</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1" name="viewport"/>
<meta content="" name="description"/>
<meta content="" name="author"/>
<!-- BEGIN GLOBAL MANDATORY STYLES -->
<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/uniform/css/uniform.default.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css"/>
<!-- END GLOBAL MANDATORY STYLES -->
<!-- BEGIN PAGE LEVEL PLUGIN STYLES -->
<link href="../assets/global/plugins/bootstrap-daterangepicker/daterangepicker-bs3.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/fullcalendar/fullcalendar.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/jqvmap/jqvmap/jqvmap.css" rel="stylesheet" type="text/css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/bootstrap-select/bootstrap-select.min.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/select2/select2.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/jquery-multi-select/css/multi-select.css"/>
<!-- END PAGE LEVEL PLUGIN STYLES -->
<!-- BEGIN PAGE STYLES -->
<link href="../assets/admin/pages/css/tasks.css" rel="stylesheet" type="text/css"/>
<!-- END PAGE STYLES -->
<!-- BEGIN THEME STYLES -->
<link href="../assets/global/css/components.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/css/plugins.css" rel="stylesheet" type="text/css"/>
<link href="../assets/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
<link href="../assets/admin/layout/css/themes/default.css" rel="stylesheet" type="text/css" id="style_color"/>
<link href="../assets/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
<!-- END THEME STYLES -->
    <link rel="shortcut icon" href="../img/smart.ico"/>




<link rel="stylesheet" type="text/css" href="../assets/global/plugins/select2/select2.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/datatables/extensions/Scroller/css/dataTables.scroller.min.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/datatables/extensions/ColReorder/css/dataTables.colReorder.min.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css"/>
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<!-- DOC: Apply "page-header-fixed-mobile" and "page-footer-fixed-mobile" class to body element to force fixed header or footer in mobile devices -->
<!-- DOC: Apply "page-sidebar-closed" class to the body and "page-sidebar-menu-closed" class to the sidebar menu element to hide the sidebar by default -->
<!-- DOC: Apply "page-sidebar-hide" class to the body to make the sidebar completely hidden on toggle -->
<!-- DOC: Apply "page-sidebar-closed-hide-logo" class to the body element to make the logo hidden on sidebar toggle -->
<!-- DOC: Apply "page-sidebar-hide" class to body element to completely hide the sidebar on sidebar toggle -->
<!-- DOC: Apply "page-sidebar-fixed" class to have fixed sidebar -->
<!-- DOC: Apply "page-footer-fixed" class to the body element to have fixed footer -->
<!-- DOC: Apply "page-sidebar-reversed" class to put the sidebar on the right side -->
<!-- DOC: Apply "page-full-width" class to the body element to have full width page without the sidebar menu -->
<body class="page-header-fixed page-quick-sidebar-over-content">
<?php require_once('../inc/header.php');?>
<!-- BEGIN CONTAINER -->
<div class="page-container">
	<?php require_once('../inc/menu.php');?>
	<!-- BEGIN CONTENT -->
	<div class="page-content-wrapper">
		<div class="page-content">
			
			<div class="page-bar rounded-4">
                <ul class="page-breadcrumb">
                    <li>
                        <i class="icon-plus"></i>
                        <strong>admissions </strong>
                        <i class="fa fa-angle-right"></i>
                        <strong>Create & Activate Intake Types</strong>
                    </li>
                </ul>

				<div class="page-toolbar">
					<div id="dashboard-report-range" class="pull-right rounded-4 tooltips btn btn-fit-height grey-salt" data-placement="top" data-original-title="Change dashboard date range">
						<i class="icon-calendar"></i>&nbsp;
						<span class="thin uppercase visible-lg-inline-block">&nbsp;</span>&nbsp;
						<i class="fa fa-angle-down"></i>
					</div>
				</div>
			</div>
			<!-- END PAGE HEADER-->
			<!-- BEGIN DASHBOARD STATS -->
			
			<!-- END DASHBOARD STATS -->
			
             <div class="row">

				<div class="col-lg-12 col-md-12  col-sm-12">

                    <form method="post" name="" id="iform"  action="">

                        <table class="table table-bordered table-condensed table-responsive" >


                            <tr>

                                <td style="width:100px;"><strong>Intake Month:</strong></td>
                                <td style="width:200px;">
                                    <select id="date_m" name="date_m" class="form-control"  style="height: 35px;">
                                        <option selected disabled>--SELECT INTAKE MONTH--</option>
                                        <?php for($m=1; $m<=12; $m++){ $month = date('F',mktime(0,0,0,$m,1,date('Y')))?>
                                            <?php if($m==1 || $m==5 || $m==9){?>
                                                <option value="<?php echo $m; ?>"><?php echo $month; ?></option>
                                            <?php } ?>
                                        <?php }?>
                                    </select><div id="dm_error"></div>
                                </td>

                                <td style="width:100px;"><strong>Intake Year:</strong></td>
                                <td style="width:200px;">
                                    <select id="date_y" name="date_y" class="form-control" style="height: 35px;">>
                                        <option selected disabled>--SELECT INTAKE YEAR--</option>
                                        <?php for(($i=date('Y')); $i<=date('Y')+1; $i++){?>
                                            <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                                        <?php }?>
                                    </select><div id="dy_error"></div>
                                </td>




                                <td style="width:65px;"><input type="submit" name="add" id="add" class="btn btn-primary rounded-4" value="Add"></td>
                            </tr>
                        </table>

                    </form>

				</div>

                 <hr>

                 <div>
                     <p align="center" style="display: none; color: limegreen;" id="wait"><img src="../img/select2/spinner.gif" > Saving. Please wait....</p>
                 </div>
                 <br><br>
                 <div class="container-fluid"><div class="span3"><h5><strong>List of Intake Types</strong></h5></div><div class="span2" id="wait" style="display: none; color: green;"><img src="../img/select2/spinner.gif" style="float: left;"><div style="float: right;">Activating Waiting....</div></div><div class="span5" id="confact"></div></div>


                 <div id="int_list" class="container-fluid">

                     <?php if($icount){?>

                         <table class="table table-bordered table-striped table-hover">
                             <thead>
                             <tr>

                                 <th>
                                     Intake Name
                                 </th>

                                 <th>
                                     Date
                                 </th>

                                 <th>
                                     Status
                                 </th>
                                 <th>&nbsp;</th>




                             </tr>
                             <hr>
                             </thead>
                             <tbody>

                             <!-- row -->
                             <?php while(!$intakelist->EndOfSeek()){ $irow = $intakelist->Row();?>
                                 <tr>

                                     <td><?php echo $irow->intake_name;?></td>
                                     <td><?php echo $irow->date_month;?></td>
                                     <td><?php if( $irow->status ==strtolower("Active")){?><font style="color:red; font-weight: bold;"><?php echo $irow->status; ?></font><?php }else{ echo $irow->status;}?></td>
                                     <td style="width:100px;"><?php if($irow->status ==strtolower("Inactive")){ ?><a id="actbtn" name="<?php echo $irow->id;?>" class="btn btn-success btn-block rounded-4" href="">Activate</a><?php } ?></td>

                                 </tr>
                             <?php }?>

                             </tbody>
                         </table>
                     <?php } ?>
                 </div>

			</div>

		 
		</div>
	 </div>
    </div>



	<!-- END CONTENT -->
	<!-- BEGIN QUICK SIDEBAR -->

	
<!-- END CONTAINER -->
<?php require_once('../inc/footer.php');?>
<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
<!-- BEGIN CORE PLUGINS -->
<!--[if lt IE 9]>
<script src="../assets/global/plugins/respond.min.js"></script>
<script src="../assets/global/plugins/excanvas.min.js"></script> 
<![endif]-->
<script src="../assets/global/plugins/jquery.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
<!-- IMPORTANT! Load jquery-ui-1.10.3.custom.min.js before bootstrap.min.js to fix bootstrap tooltip conflict with jquery ui tooltip -->
<script src="../assets/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery.blockui.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery.cokie.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/uniform/jquery.uniform.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js" type="text/javascript"></script>
<!-- END CORE PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script src="../assets/global/plugins/jqvmap/jqvmap/data/jquery.vmap.sampledata.js" type="text/javascript"></script>
<script src="../assets/global/plugins/flot/jquery.flot.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/flot/jquery.flot.resize.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/flot/jquery.flot.categories.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery.pulsate.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/bootstrap-daterangepicker/moment.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/bootstrap-daterangepicker/daterangepicker.js" type="text/javascript"></script>
<!-- IMPORTANT! fullcalendar depends on jquery-ui-1.10.3.custom.min.js for drag & drop support -->
<script src="../assets/global/plugins/fullcalendar/fullcalendar.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery-easypiechart/jquery.easypiechart.min.js" type="text/javascript"></script>
<script src="../assets/global/plugins/jquery.sparkline.min.js" type="text/javascript"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="../assets/global/scripts/metronic.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/layout.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/quick-sidebar.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/demo.js" type="text/javascript"></script>
<script src="../assets/admin/pages/scripts/index.js" type="text/javascript"></script>
<script src="../assets/admin/pages/scripts/tasks.js" type="text/javascript"></script>

<!-- BEGIN PAGE LEVEL PLUGINS -->
<script type="text/javascript" src="../assets/global/plugins/select2/select2.min.js"></script>
<!-- END PAGE LEVEL PLUGINS -->

<script src="../assets/global/scripts/metronic.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/layout.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/quick-sidebar.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/demo.js" type="text/javascript"></script>



<script type="text/javascript" src="../assets/global/plugins/bootstrap-select/bootstrap-select.min.js"></script>
<script type="text/javascript" src="../assets/global/plugins/select2/select2.min.js"></script>
<script type="text/javascript" src="../assets/global/plugins/jquery-multi-select/js/jquery.multi-select.js"></script>

<script src="../assets/global/scripts/metronic.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/layout.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/quick-sidebar.js" type="text/javascript"></script>
<script src="../assets/admin/layout/scripts/demo.js" type="text/javascript"></script>
<script src="../assets/admin/pages/scripts/components-pickers.js"></script>
<script src="../assets/admin/pages/scripts/components-dropdowns.js"></script>

<script type="text/javascript" charset="utf8">

    $(function () {

        var $btns = $("#add");
        $btns.click(function (e) {
            e.preventDefault();
            $("#dm_error").empty();
            $("#dy_error").empty();

            var dm = $.trim($("#date_m").val());
            var dy = $.trim($("#date_y").val());


            if(dm.length == 0){

                $("#dm_error").html('<p style="color: red;"><small>no option selected</small></p>');

            }

            if(dy.length == 0){

                $("#dy_error").html('<p style="color: red;"><small>no option selected</small></p>');

            }


            if(dm.length!=0 && dy.length!=0) {
                $("#wait").css("display", "block");
                $("#add").attr("disabled", "disabled");

                $.ajax({
                    type: "POST",
                    url: "itype.php",
                    data: $('#iform').serialize(),
                    success: function (msg) {

                        if (msg == "fail") {

                            $("#wait").css("display", "none");
                            $("#add").removeAttr('disabled');
                            $('#name').val("");
                            $('#confirmation').html("<p class='alert alert-danger' style='text-align: center'><i class='icon-remove-sign'></i> Complete all fields before submitting</p>");
                            $("#confirmation").hide().fadeIn(2000);

                        }else if(msg == "exists_already") {

                            $("#wait").css("display", "none");
                            $("#add").removeAttr('disabled');
                            $('#name').val("");
                            $('#confirmation').html("<p class='alert alert-danger' style='text-align: center'><i class='icon-remove-sign'></i>Intake type creation failed. The intake type youre attempting to create already exists.</p>");
                            $("#confirmation").hide().fadeIn(2000);

                        }else{

                            $("#wait").css("display", "none");
                            $("#add").removeAttr('disabled');
                            $("#date_m").val($("#date_m option:first").val());
                            $("#date_y").val($("#date_y option:first").val());
                            $('#int_list').html(msg);
                            $('#name').val("");
                            $('#confirmation').html("<p class='alert alert-success' style='text-align: center'><i class='icon-ok-sign'></i> Intake Type was added successfully</p>")
                            $("#confirmation").hide().fadeIn(2000).fadeOut(4000);

                        }


                    }
                });
                return false;
            }

        });

    });


    $(document).on("click","#actbtn",function(e){

        e.preventDefault();
        if(confirm("Are you sure you want to activate this academic year? Take Note : This actin may affect other processes on this system. Thank you.")){

            var dropvalue = $(this).attr('name');
            $("#wait").css("display","block");
            $("a[id*=actbtn]").attr("disabled","disabled");

            $.ajax({
                type: "POST",
                url: "activate.php",
                data: {tid : dropvalue},
                success:function(sdata) {

                    if(sdata=="fail"){

                        $("#wait").css("display","none");
                        $('#confact').html("<p class='alert alert-danger' style='text-align: center'><i class='icon-remove-sign'></i>Intake type activation failed.</p>");
                        $("#confact").hide().fadeIn(2000).fadeOut(5000);
                    }else{
                        $("#wait").css("display","none");
                        $('#int_list').html(sdata);
                    }


                }

            });


        }

    });
</script>
<script>
jQuery(document).ready(function() {
   Metronic.init(); // init metronic core componets
   Layout.init(); // init layout
   QuickSidebar.init(); // init quick sidebar
   Demo.init(); // init demo features 
   Index.init();   
   Index.initDashboardDaterange();
   //Index.initJQVMAP(); // init index page's custom scripts
   Index.initCalendar(); // init index page's custom scripts
    //ComponentsDropdowns.init();
   Tasks.initDashboardWidget();
    //TableAdvanced.init();

});
</script>

<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html>