<?php
if(!isset($_SESSION)){
    session_start();
}

require_once('mysql.class.php');

class broadsheet extends MySQL{

    function __construct(){
        parent::__construct();
    }

    function  getCourseCode($courseid){

        $cid = $courseid;
        $this->Query("SELECT code,credit FROM main_courses WHERE id = $cid");
        $courserw = $this->Row();

        $code = $courserw->code.' ['.$courserw->credit.']';
        if(isset($code)){

            return $code;

        }else{

            return "N/A";

        }

    }


    function  getTrailedCourse($courseid){

        $cid = $courseid;
        $this->Query("SELECT code,credit FROM main_courses WHERE id = $cid");
        $courserw = $this->Row();

        $code = $courserw->code;
        if(isset($code)){

            return $code;

        }else{

            return "N/A";

        }

    }

    function getBroadsheetStudentName($indexnumber){

        $inum = trim($indexnumber);
        $this->Query("SELECT last_name,first_name,middle_name FROM stud_main WHERE reg_number = '$inum'");
        $count = $this->RowCount();

        if($count > 0){
            $namerow = $this->Row();
            $theName = strtoupper($namerow->last_name).', '.ucwords(strtolower($namerow->first_name)).' '.ucwords(strtolower($namerow->middle_name));
            return $theName;

        }else{

            return "NAME NOT FOUND";

        }

    }

    function  getCourseDefinition($courseid){

        $cid = $courseid;
        $this->Query("SELECT code,credit,name FROM main_courses WHERE id = $cid");
        $courserw = $this->Row();

        $code = '<strong>'.$courserw->code.' : '.$courserw->name.' ['.$courserw->credit.']'.'</strong>';
        if(isset($code)){

            return $code;

        }else{

            return "N/A";

        }

    }

    function getMyMark($program,$level,$semester,$idnum,$course){


        $bsdataquery = "SELECT gb_main.totalscore FROM gb_main LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id WHERE gb_header.program_code = '$program'
        AND gb_header.`level` = $level  AND gb_header.gb_years_id = $semester AND gb_main.indexnumber = '$idnum' AND gb_header.courseid = $course";


        $this->Query($bsdataquery);
        $mrow = $this->Row();
        if(is_object($mrow)){

            $val = base64_decode($mrow->totalscore);
            if(isset($val)){

                return (double)$val;

            }else{

                return (double)0;

            }

        }else{

            return "<strong style='color: #000000'>-</strong>";

        }

    }


    function getCredit($courseid){

        $cid = $courseid;
        $this->Query("SELECT credit FROM main_courses WHERE id = $cid");
        $crRow = $this->Row();

        if(is_object($crRow)){

            return $crRow->credit;

        }else{

            return 0;

        }


    }

    function standardDeviation($cid,$program,$level,$semester,$intake){

        if(isset($intake) && !empty($intake)){

            $postIntake = $intake;
            $thisYear = date("Y");
            $thisMonth = date("m");
            $newYear = 0;
            $intakePortion = " AND stud_main.doa = ";

            if($thisMonth > 9){
                if($postIntake==1){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }

            }elseif($thisMonth < 9){

                if($postIntake==1){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear - 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }
            }


        }else{

            $buildDOAFilter = "";
            $intakePortion = "";
            $postIntake = 0;

        }

        $themean = $this->calcMean($cid,$program,$level,$semester,$intake);


        $this->Query("SELECT * FROM gb_main LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                      LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.program_code = '$program'
                      AND gb_header.`level` = $level  AND gb_header.gb_years_id = $semester
                      AND stud_main.`status` = 'active' AND gb_header.courseid = $cid
                      AND gb_main.resit = 0 $intakePortion");

        $squaredDiff = 0;
        while(!$this->EndOfSeek()){

            $mark = $this->Row();
            $difference = $mark->totalscore - $themean;

            $squaredDiff += pow($difference,2);

        }

        $this->Query("SELECT * FROM gb_main LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                      LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.program_code = '$program' AND gb_header.`level` = $level AND gb_header.gb_years_id = $semester
                      AND stud_main.`status` = 'active' AND gb_header.courseid = $cid
                      AND gb_main.resit = 0 $intakePortion");

        $count = $this->RowCount();

        if($count==0 || is_null($count)){

            $variance = 0;

        }else{

            $variance = $squaredDiff/$count;

        }

        return (float) round(sqrt($variance),3);

    }

    function calcMean($cid,$program,$level,$semester,$intake){

        if(isset($intake) && !empty($intake)){

            $postIntake = $intake;
            $thisYear = date("Y");
            $thisMonth = date("m");
            $newYear = 0;
            $intakePortion = " AND stud_main.doa = ";

            if($thisMonth > 9){
                if($postIntake==1){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }

            }elseif($thisMonth < 9){

                if($postIntake==1){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear - 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }
            }


        }else{

            $buildDOAFilter = "";
            $intakePortion = "";
            $postIntake = 0;

        }

        $this->Query("SELECT * FROM gb_main LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                      LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.program_code = '$program'
                      AND gb_header.`level` = $level  AND gb_header.gb_years_id = $semester
                      AND stud_main.`status` = 'active' AND gb_header.courseid = $cid
                      AND gb_main.resit = 0 $intakePortion");

        $rcount = $this->RowCount();

        $this->Query("SELECT SUM(FROM_BASE64(gb_main.totalscore)) as gradesum FROM gb_main
                      LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                       LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.program_code = '$program'
                      AND gb_header.`level` = $level  AND gb_header.gb_years_id = $semester
                      AND stud_main.`status` = 'active' AND gb_header.courseid = $cid AND gb_main.resit = 0 $intakePortion");

        $gsrow = $this->Row();
        $gradesum = $gsrow->gradesum;

        if($rcount==0 || is_null($rcount)){

            return (float) 0;

        }else{

            $finalMean = $gradesum/$rcount;
            return (float) round($finalMean,2);

        }



    }

    function getStatCourses(){

        $courses = array();
        $headid = array();
        $pro = $_POST['program'];
        $lev = $_POST['level'];
        $sem = $_POST['semester'];
        $intake = $_POST['intake'];

        $theadquery = "SELECT DISTINCT(main_courses.`code`) as coursecode,main_courses.credit as cred,program_courses.courseid as setupcourses, program_courses.program_code, main_courses.`name` as coursename
                      FROM program_courses
                      LEFT JOIN gb_header ON program_courses.courseid = gb_header.courseid
                      LEFT JOIN main_courses ON program_courses.courseid = main_courses.id
                      WHERE program_courses.program_code = '$pro' AND program_courses.level = '$lev' AND program_courses.semester = $sem AND program_courses.status = 1";

        $this->Query($theadquery);

        while(!$this->EndOfSeek()) {
            $hrow = $this->Row();
            $courses[] = $hrow->setupcourses;
        }


        $outputTable = "<table class='table table-bordered'><tr><td>&nbsp;</td>";
        foreach($courses as $acourse){

            $outputTable .= "<td style='color: blue;'>".$this->getCourseDefinition($acourse)."</td>";

        }


        $outputTable .= "</tr><tr><td style='color: #0000ff;'><strong>MEAN: </strong></td>";

        foreach($courses as $acourseme){

            $outputTable .= "<td style='color:black;'><strong>".$this->calcMean($acourseme,$pro,$lev,$sem,$intake)."</strong></td>";

        }
        $outputTable .= "</tr>";

        $outputTable .= "</tr><tr><td style='color: #0000ff;'><strong>STANDARD DEVIATION: </strong></td>";

        foreach($courses as $acoursesd){

            $outputTable .= "<td style='color: red;'><strong>".$this->standardDeviation($acoursesd,$pro,$lev,$sem,$intake)."</strong></td>";

        }
        $outputTable .= "</tr>";


        $outputTable .= "</tr><tr><td style='color: #0000ff;'><strong>DISTRIBUTION: </strong></td>";

        foreach($courses as $acoursedis){

            $outputTable .= "<td>".$this->GradeCounter($acoursedis,$pro,$lev,$sem,$intake)."</td>";

        }
        $outputTable .= "</tr>";


        $outputTable .= "</tr><tr><td>&nbsp;</td>";

        foreach($courses as $acoursegr){

            $outputTable .= "<td>".$this->buildBroadsheetGraph($acoursegr,$pro,$lev,$sem,$intake)."</td>";

        }
        $outputTable .= "</tr></table>
<script type=\"text/javascript\">
function MM_openBrWindow(theURL,winName,features) { //v2.0
  window.open(theURL,winName,features);
}
    </script>";

        return $outputTable;
    }



    function GradeCounter($cid,$program,$level,$semester,$intake){

        if(isset($intake) && !empty($intake)){

            $postIntake = $intake;
            $thisYear = date("Y");
            $thisMonth = date("m");
            $newYear = 0;
            $intakePortion = " AND stud_main.doa = ";

            if($thisMonth > 9){
                if($postIntake==1){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }

            }elseif($thisMonth < 9){

                if($postIntake==1){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear - 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }
            }


        }else{

            $buildDOAFilter = "";
            $intakePortion = "";
            $postIntake = 0;

        }

        $gcquery = "SELECT FROM_BASE64(gb_main.totalscore) as totscore,gb_header.grading_system FROM gb_main LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                      LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.program_code = '$program'
                      AND gb_header.`level` = $level  AND gb_header.gb_years_id = $semester
                      AND stud_main.`status` = 'active' AND gb_main.resit = 0
                      AND gb_header.courseid = $cid $intakePortion";

        $this->Query($gcquery);

        $A = NULL;
        $Amin = NULL;
        $B = NULL;
        $Bplus = NULL;
        $Bmin = NULL;
        $C = NULL;
        $Cplus = NULL;
        $D = NULL;
        $Dplus = NULL;
        $E = NULL;
        $F = NULL;

        while(!$this->EndOfSeek()){ $rc = $this->Row();

            $thescore = $rc->totscore;
            $thegs = $rc->grading_system;

            $getGrade = $this->gradeScoreUpdatedManual($thescore,$thegs);

            if($getGrade == "A"){

                $A += 1;
            }elseif($getGrade == "A-"){
                if($Amin==NULL){
                    $Amin = 0;
                }
                $Amin += 1;

            }elseif($getGrade == "B"){
                if($B==NULL){
                    $B = 0;
                }
                $B += 1;

            }elseif($getGrade == "B+"){
                if($Bplus==NULL){
                    $Bplus = 0;
                }
                $Bplus += 1;

            } elseif($getGrade == "B-"){
                if($Bmin==NULL){
                    $Bmin = 0;
                }
                $Bmin += 1;

            } elseif($getGrade == "C+"){
                if($Cplus==NULL){
                    $Cplus = 0;
                }
                $Cplus += 1;

            } elseif($getGrade == "C"){
                if($C==NULL){
                    $C = 0;
                }
                $C += 1;

            } elseif($getGrade == "D+"){
                if($Dplus==NULL){
                    $Dplus = 0;
                }
                $Dplus += 1;

            } elseif($getGrade == "D"){
                if($D==NULL){
                    $D = 0;
                }
                $D += 1;

            } elseif($getGrade == "E"){
                if($E==NULL){
                    $E = 0;
                }
                $E += 1;

            } elseif($getGrade == "F"){
                if($F==NULL){
                    $F = 0;
                }
                $F += 1;

            }

        }
        $gdist = "";
        if($A != NULL){
            $gdist .= "<strong>A</strong> : <font color='black'><strong>".$A.'</strong></font><br>  ';
        }
        if($Amin != NULL){
            $gdist .= "<strong>A-</strong> : <font color='black'><strong>".$Amin.'</strong></font><br>  ';
        }
        if($Bplus != NULL){
            $gdist .= "<strong>B+</strong> : <font color='black'><strong>".$Bplus.'</strong></font><br>  ';
        }
        if($B != NULL){
            $gdist .= "<strong>B</strong> : <font color='black'><strong>".$B.'</strong></font><br>  ';
        }
        if($Bmin != NULL){
            $gdist .= "<strong>B-</strong> : <font color='black'><strong>".$Bmin.'</strong></font><br>  ';
        }
        if($Cplus != NULL){
            $gdist .= "<strong>C+</strong> : <font color='black'><strong>".$Cplus.'</strong></font><br>  ';
        }
        if($C != NULL){
            $gdist .= "<strong>C</strong> : <font color='black'><strong>".$C.'</strong></font><br>  ';
        }
        if($Dplus != NULL){
            $gdist .= "<strong>D+</strong> : <font color='black'><strong>".$Dplus.'</strong></font><br>  ';
        }
        if($D != NULL){
            $gdist .= "<strong>D</strong> : <font color='black'><strong>".$D.'</strong></font><br>  ';
        }
        if($E != NULL){
            $gdist .= "<strong>E</strong> : <font color='black'><strong>".$E.'</strong></font><br>  ';
        }
        if($F != NULL){
            $gdist .= "<strong>F</strong> : <font color='black'><strong>".$F.'</strong></font><br>  ';
        }
        return $gdist;



    }

    function buildBroadsheetGraph($cid,$program,$level,$semester,$intake){
        if(isset($intake) && !empty($intake) && $intake != 0){

            $postIntake = (int)trim($intake);
            $thisYear = date("Y");
            $thisMonth = date("m");
            $newYear = 0;
            $intakePortion = " AND stud_main.doa = ";

            if($thisMonth > 9){
                if($postIntake==1){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear + 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }

            }elseif($thisMonth < 9){

                if($postIntake==1){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear - 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }
            }elseif($thisMonth == 9){

                if($postIntake==1){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==5){

                    $newYear = $thisYear;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }elseif($postIntake==9){

                    $newYear = $thisYear - 1;
                    $buildDOAFilter = $postIntake.'-'.$newYear;
                    $intakePortion .= "'$buildDOAFilter'";

                }

            }


        }else{

            $buildDOAFilter = "";
            $intakePortion = "";
            $postIntake = 0;

        }

        $gcquery = "SELECT FROM_BASE64(gb_main.totalscore) as totscore,gb_header.grading_system FROM gb_main
                      LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                      LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.program_code = '$program'
                      AND gb_header.`level` = $level  AND gb_header.gb_years_id = $semester
                      AND stud_main.`status` = 'active' AND gb_main.resit = 0
                      AND gb_header.courseid = $cid $intakePortion";

        $this->Query($gcquery);

        $A = NULL;
        $Amin = NULL;
        $B = NULL;
        $Bplus = NULL;
        $Bmin = NULL;
        $C = NULL;
        $Cplus = NULL;
        $D = NULL;
        $Dplus = NULL;
        $E = NULL;
        $F = NULL;

        while(!$this->EndOfSeek()){ $rc = $this->Row();

            $thescore = $rc->totscore;
            $thegs = $rc->grading_system;

            $getGrade = $this->gradeScoreUpdatedManual($thescore,$thegs);

            if($getGrade == "A"){
                if($A==NULL){
                    $A = 0;
                }
                $A += 1;
            }elseif($getGrade == "A-"){
                if($Amin==NULL){
                    $Amin = 0;
                }
                $Amin += 1;

            }elseif($getGrade == "B"){
                if($B==NULL){
                    $B = 0;
                }
                $B += 1;

            }elseif($getGrade == "B+"){
                if($Bplus==NULL){
                    $Bplus = 0;
                }
                $Bplus += 1;

            } elseif($getGrade == "B-"){
                if($Bmin==NULL){
                    $Bmin = 0;
                }
                $Bmin += 1;

            } elseif($getGrade == "C+"){
                if($Cplus==NULL){
                    $Cplus = 0;
                }
                $Cplus += 1;

            } elseif($getGrade == "C"){
                if($C==NULL){
                    $C = 0;
                }
                $C += 1;

            } elseif($getGrade == "D+"){
                if($Dplus==NULL){
                    $Dplus = 0;
                }
                $Dplus += 1;

            } elseif($getGrade == "D"){
                if($D==NULL){
                    $D = 0;
                }
                $D += 1;

            } elseif($getGrade == "E"){
                if($E==NULL){
                    $E = 0;
                }
                $E += 1;

            } elseif($getGrade == "F"){
                if($F==NULL){
                    $F = 0;
                }
                $F += 1;

            }

        }
        $gdist = "broadsheet_dis_graph.php?";
        $suff = "cid=".$cid;
        if($A != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "a=".$A;
        }
        if($Amin != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "am=".$Amin;
        }
        if($Bplus != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "bp=".$Bplus;
        }
        if($B != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "b=".$B;
        }
        if($Bmin != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "bm=".$Bmin;
        }
        if($Cplus != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "cp=".$Cplus;
        }
        if($C != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "c=".$C;
        }
        if($Dplus != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "dp=".$Dplus;
        }
        if($D != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "d=".$D;
        }
        if($E != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "e=".$E;
        }
        if($F != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "f=".$F;
        }

        $mylink = "";
        $inlink = $gdist.$suff;

        $mylink = "<a href='#' onClick=\"MM_openBrWindow('$inlink','broadsheetdisgraph','status=yes,scrollbars=yes,width=550,height=400')\">"."Show Graph"."</a>";
        return $mylink;






    }



    function buildGradebookGraph($headerid){

        $this->Query("SELECT courseid FROM gb_header WHERE id = $headerid");
        $cidrow = $this->Row();
        $cid = $cidrow->courseid;

        $gcquery = "SELECT FROM_BASE64(gb_main.totalscore) as totscore,gb_header.grading_system FROM gb_main LEFT JOIN gb_header ON gb_main.gb_header_id = gb_header.id
                      LEFT JOIN stud_main ON FROM_BASE64(gb_main.indexnumber) = stud_main.reg_number
                      WHERE gb_header.id = $headerid
                      AND stud_main.`status` = 'active' AND gb_main.resit = 0";

        $this->Query($gcquery);

        $A = NULL;
        $Amin = NULL;
        $B = NULL;
        $Bplus = NULL;
        $Bmin = NULL;
        $C = NULL;
        $Cplus = NULL;
        $D = NULL;
        $Dplus = NULL;
        $E = NULL;
        $F = NULL;

        while(!$this->EndOfSeek()){ $rc = $this->Row();

            $thescore = $rc->totscore;
            $thegs = $rc->grading_system;

            $getGrade = $this->gradeScoreUpdatedManual($thescore,$thegs);

            if($getGrade == "A"){
                if($A==NULL){
                    $A = 0;
                }
                $A += 1;
            }elseif($getGrade == "A-"){
                if($Amin==NULL){
                    $Amin = 0;
                }
                $Amin += 1;

            }elseif($getGrade == "B"){
                if($B==NULL){
                    $B = 0;
                }
                $B += 1;

            }elseif($getGrade == "B+"){
                if($Bplus==NULL){
                    $Bplus = 0;
                }
                $Bplus += 1;

            } elseif($getGrade == "B-"){
                if($Bmin==NULL){
                    $Bmin = 0;
                }
                $Bmin += 1;

            } elseif($getGrade == "C+"){
                if($Cplus==NULL){
                    $Cplus = 0;
                }
                $Cplus += 1;

            } elseif($getGrade == "C"){
                if($C==NULL){
                    $C = 0;
                }
                $C += 1;

            } elseif($getGrade == "D+"){
                if($Dplus==NULL){
                    $Dplus = 0;
                }
                $Dplus += 1;

            } elseif($getGrade == "D"){
                if($D==NULL){
                    $D = 0;
                }
                $D += 1;

            } elseif($getGrade == "E"){
                if($E==NULL){
                    $E = 0;
                }
                $E += 1;

            } elseif($getGrade == "F"){
                if($F==NULL){
                    $F = 0;
                }
                $F += 1;

            }

        }
        $gdist = "broadsheet_dis_graph.php?";
        $suff = "cid=".$cid;
        if($A != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "a=".$A;
        }
        if($Amin != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "am=";
        }
        if($Bplus != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "bp=".$Bplus;
        }
        if($B != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "b=".$B;
        }
        if($Bmin != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "bm=".$Bmin;
        }
        if($Cplus != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "cp=".$Cplus;
        }
        if($C != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "c=".$C;
        }
        if($Dplus != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "dp=".$Dplus;
        }
        if($D != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "d=".$D;
        }
        if($E != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "e=".$E;
        }
        if($F != NULL){
            if(!empty($suff)){
                $suff.= "&";
            }
            $suff .= "f=".$F;
        }

        $mylink = "";
        $inlink = $gdist.$suff;

        $mylink = "<a href='#' class='btn btn-default btn-xs rounded-4' onClick=\"MM_openBrWindow('$inlink','broadsheetdisgraph','status=yes,scrollbars=yes,width=550,height=400')\">"."Show Grade Distribution Graph"."</a>";
        return $mylink;






    }


    function publishResults(){

        $pro = $_POST['pubpro'];
        $lev = $_POST['publevel'];
        $sem = $_POST['pubsemester'];
        $intake = $_POST['pubintake'];
        $prefix = "UPDATE gb_header SET status = 'published' ";
        $wherePart = "WHERE ";

        $publishQuery = "SELECT gb_header.id FROM program_courses
                      LEFT JOIN gb_header ON program_courses.courseid = gb_header.courseid
                      LEFT JOIN main_courses ON program_courses.courseid = main_courses.id
                      WHERE program_courses.program_code = '$pro' AND program_courses.level = '$lev' AND program_courses.semester = $sem AND program_courses.status = 1";
        $this->Query($publishQuery);

        while(!$this->EndOfSeek()){

            $header = $this->Row();
            $wherePart .= " id = ". $header->id;

            if(!$this->EndOfSeek()){
            $wherePart .=" OR ";
            }

        }

        $final =  $prefix.$wherePart;

        $result = $this->Query($final);
        if($result){
            return "ok";
        }else{
            return "fail";
        }


    }


}//end of class


if(isset($_POST['program']) && isset($_POST['do']) && $_POST['do']=="getStatsForTheseCourses"){

    $bsheet = new broadsheet();
    echo $bsheet->getStatCourses();exit;

}

if(isset($_POST['pubpro']) && isset($_POST['do']) && $_POST['do']=="publishIt"){

    $bsheet = new broadsheet();
    echo $bsheet->publishResults();exit;

}
?>