<?php 
$page = "fin";
require_once('../classes/mysql.class.php');

$security = new MySQL();
$security->checkLogin();

$getRefReq = new MySQL();
$getRefReq->Query("SELECT refund_requests.id,stud_bill.index_num,IFNULL(SUM(debit),0) as debit, IFNULL(SUM(credit),0) as credit,first_name,middle_name,last_name,ref_amount,refund_requests.created_on FROM stud_bill
                   LEFT JOIN refund_requests ON stud_bill.index_num = refund_requests.index_number
                   LEFT JOIN stud_main ON stud_main.reg_number = stud_bill.index_num
                   WHERE refund_requests.status = 'pending' AND stud_bill.status = 'approved'
                   GROUP BY stud_bill.index_num ,first_name,middle_name,last_name,ref_amount,refund_requests.created_on,refund_requests.id");



?>
<!DOCTYPE html>
<html lang="en" class="no-js">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
<meta charset="utf-8"/>
<title>SMART | Refund Request</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1" name="viewport"/>
<meta content="" name="description"/>
<meta content="" name="author"/>
<!-- BEGIN GLOBAL MANDATORY STYLES -->
<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/uniform/css/uniform.default.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css"/>
<!-- END GLOBAL MANDATORY STYLES -->
<!-- BEGIN PAGE LEVEL PLUGIN STYLES -->
<link href="../assets/global/plugins/bootstrap-daterangepicker/daterangepicker-bs3.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/fullcalendar/fullcalendar.min.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/plugins/jqvmap/jqvmap/jqvmap.css" rel="stylesheet" type="text/css"/>
<!-- END PAGE LEVEL PLUGIN STYLES -->
<!-- BEGIN PAGE STYLES -->
<link href="../assets/admin/pages/css/tasks.css" rel="stylesheet" type="text/css"/>
<!-- END PAGE STYLES -->
<!-- BEGIN THEME STYLES -->
<link href="../assets/global/css/components.css" rel="stylesheet" type="text/css"/>
<link href="../assets/global/css/plugins.css" rel="stylesheet" type="text/css"/>
<link href="../assets/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
<link href="../assets/admin/layout/css/themes/default.css" rel="stylesheet" type="text/css" id="style_color"/>
<link href="../assets/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
<!-- END THEME STYLES -->
<link rel="shortcut icon" href="../img/smart.ico"/>



<link rel="stylesheet" type="text/css" href="../assets/global/plugins/select2/select2.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/datatables/extensions/Scroller/css/dataTables.scroller.min.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/datatables/extensions/ColReorder/css/dataTables.colReorder.min.css"/>
<link rel="stylesheet" type="text/css" href="../assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css"/>
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<!-- DOC: Apply "page-header-fixed-mobile" and "page-footer-fixed-mobile" class to body element to force fixed header or footer in mobile devices -->
<!-- DOC: Apply "page-sidebar-closed" class to the body and "page-sidebar-menu-closed" class to the sidebar menu element to hide the sidebar by default -->
<!-- DOC: Apply "page-sidebar-hide" class to the body to make the sidebar completely hidden on toggle -->
<!-- DOC: Apply "page-sidebar-closed-hide-logo" class to the body element to make the logo hidden on sidebar toggle -->
<!-- DOC: Apply "page-sidebar-hide" class to body element to completely hide the sidebar on sidebar toggle -->
<!-- DOC: Apply "page-sidebar-fixed" class to have fixed sidebar -->
<!-- DOC: Apply "page-footer-fixed" class to the body element to have fixed footer -->
<!-- DOC: Apply "page-sidebar-reversed" class to put the sidebar on the right side -->
<!-- DOC: Apply "page-full-width" class to the body element to have full width page without the sidebar menu -->
<body class="page-header-fixed page-quick-sidebar-over-content">
<?php require_once('../inc/header.php');?>
<div class="clearfix">
</div>
<!-- BEGIN CONTAINER -->
<div class="page-container">
	<?php require_once('../inc/menu.php');?>
	<!-- BEGIN CONTENT -->
	<div class="page-content-wrapper">
		<div class="page-content">
			
			
			
			<div class="page-bar rounded-4">

                <ul class="page-breadcrumb rounded-4">
                    <li>
                        <i class="icon-plus"></i>
                        <strong>Finance </strong>
                        <i class="fa fa-angle-right"></i>
                        <strong>Process Refund Requests </strong>
                    </li>
                </ul>
				<div class="page-toolbar">
					<div id="dashboard-report-range" class="pull-right rounded-4 tooltips btn btn-fit-height grey-salt" data-placement="top" data-original-title="Change dashboard date range">
						<i class="icon-calendar"></i>&nbsp;
						<span class="thin uppercase visible-lg-inline-block">&nbsp;</span>&nbsp;
						<i class="fa fa-angle-down"></i>
					</div>
				</div>
			</div>
			<!-- END PAGE HEADER-->
			<!-- BEGIN DASHBOARD STATS -->
			
			<!-- END DASHBOARD STATS -->
			
             <div class="container-fluid">

                 <div class="tab-content ">

                     <div id="proclist">

                    <table class="table table-bordered table-striped table-responsive table-advance" id='example'>
                        <thead>
                        <tr>
                            <td><strong>Index Number</strong></td>
                            <td><strong>Fullname</strong></td>
                            <td><strong>Total Bills</strong></td>
                            <td><strong>Total Payments</strong></td>
                            <td><strong>Excess</strong></td>
                            <td><strong>Refund Requested</strong></td>
                            <td><strong>Date Created</strong></td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                        </tr>
                        </thead>
                        <tbody>
                        <?php while(!$getRefReq->EndOfSeek()){$arow = $getRefReq->Row();?>
                            <tr>
                                <td style="color: blue"><strong><?php echo $arow->index_num;?></strong></td>
                                <td><strong><?php echo $arow->first_name.' '.$arow->middle_name.' '.$arow->last_name;?></strong></td>
                                <td><strong><?php echo $arow->debit;?></strong></td>
                                <td><strong><?php echo $arow->credit;?></strong></td>
                                <td  style="color: blue;"><strong><?php echo abs($arow->debit - $arow->credit);?></strong></td>
                                <td  style="color: red;"><strong><?php echo $arow->ref_amount;?></strong></td>
                                <td><strong><?php echo $arow->created_on;?></strong></td>
                                <td><a class="btn btn-success btn-xs rounded-4" href="#apprv" id="approveme" data-toggle="modal" name="<?php echo $arow->id;?>"><i class="glyphicon glyphicon-edit"></i> Approve</a></td>
                                <td><a class="btn btn-danger btn-xs rounded-4" href="#rjct" id="rejectme" data-toggle="modal" name="<?php echo $arow->id;?>"><i class="glyphicon glyphicon-remove-sign"></i> Reject</a></td>
                            </tr>
                        <?php }?>
                        </tbody>
                    </table>

				</div>

                 </div>

                 <div class="modal fade" id="apprv" role="dialog">
                     <div class="modal-dialog">
                         <div class="modal-content" style="width: 700px;">
                             <div>
                                 <div class="modal-header" style="text-align: center;">
                                     <button type="button" class="close" data-dismiss="modal">&times;</button>
                                     <div><h5><strong><i class="icon icon-edit"></i>Approve Refund Request</strong></h5></div>

                                 </div>
                                 <div class="modal-body">
                                     <div style="display:none; text-align: center; color: limegreen;" id="a_wait"><img src="../img/select2/spinner.gif" > processing. Please wait....</div>

                                     <div id="a_result"></div>

                                     <div id="a_record"></div>
                                 </div>
                             </div>

                         </div>

                     </div>
                 </div>

                 <div class="modal fade" id="rjct" role="dialog">
                     <div class="modal-dialog">
                         <div class="modal-content" style="width: 700px;">
                             <div>
                                 <div class="modal-header" style="text-align: center;">
                                     <button type="button" class="close" data-dismiss="modal">&times;</button>
                                     <div><h5><strong><i class="icon icon-edit"></i>Reject Refund Request</strong></h5></div>

                                 </div>
                                 <div class="modal-body">
                                     <div style="display:none; text-align: center; color: limegreen;" id="r_wait"><img src="../img/select2/spinner.gif" > processing. Please wait....</div>

                                     <div id="r_result"></div>

                                     <div id="r_record"></div>
                                 </div>
                             </div>

                         </div>

                     </div>
                 </div>


                 <div class="modal fade" id="viewmore" role="dialog">
                     <div class="modal-dialog">
                         <div class="modal-content" style="width: 700px;">
                             <div>
                                 <div class="modal-header" style="text-align: center;">
                                     <button type="button" class="close" data-dismiss="modal">&times;</button>
                                     <div><h5><strong><i class="icon icon-edit"></i>View Refund Request</strong></h5></div>

                                 </div>
                                 <div class="modal-body">
                                     <div style="display:none; text-align: center; color: limegreen;" id="v_wait"><img src="../img/select2/spinner.gif" > processing. Please wait....</div>

                                     <div id="v_result"></div>

                                     <div id="v_record"></div>
                                 </div>
                             </div>

                         </div>

                     </div>
                 </div>
			</div>


		 
		</div>
	</div>
	<!-- END CONTENT -->
	<!-- BEGIN QUICK SIDEBAR -->

	
<!-- END CONTAINER -->
<?php require_once('../inc/footer.php');?>
<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
<!-- BEGIN CORE PLUGINS -->
<!--[if lt IE 9]>
    <script src="../assets/global/plugins/respond.min.js"></script>
    <script src="../assets/global/plugins/excanvas.min.js"></script>
    <![endif]-->
    <script src="../assets/global/plugins/jquery.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
    <!-- IMPORTANT! Load jquery-ui-1.10.3.custom.min.js before bootstrap.min.js to fix bootstrap tooltip conflict with jquery ui tooltip -->
    <script src="../assets/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery.blockui.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery.cokie.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/uniform/jquery.uniform.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js" type="text/javascript"></script>
    <!-- END CORE PLUGINS -->
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="../assets/global/plugins/jqvmap/jqvmap/jquery.vmap.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.russia.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.world.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.europe.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.germany.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.usa.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jqvmap/jqvmap/data/jquery.vmap.sampledata.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/flot/jquery.flot.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/flot/jquery.flot.resize.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/flot/jquery.flot.categories.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery.pulsate.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/bootstrap-daterangepicker/moment.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/bootstrap-daterangepicker/daterangepicker.js" type="text/javascript"></script>
    <!-- IMPORTANT! fullcalendar depends on jquery-ui-1.10.3.custom.min.js for drag & drop support -->
    <script src="../assets/global/plugins/fullcalendar/fullcalendar.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery-easypiechart/jquery.easypiechart.min.js" type="text/javascript"></script>
    <script src="../assets/global/plugins/jquery.sparkline.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="../assets/admin/pages/scripts/index.js" type="text/javascript"></script>
    <script src="../assets/admin/pages/scripts/tasks.js" type="text/javascript"></script>

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script type="text/javascript" src="../assets/global/plugins/select2/select2.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/datatables/media/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/datatables/extensions/TableTools/js/dataTables.tableTools.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/datatables/extensions/ColReorder/js/dataTables.colReorder.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/datatables/extensions/Scroller/js/dataTables.scroller.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js"></script>
    <!-- END PAGE LEVEL PLUGINS -->

    <script src="../assets/admin/pages/scripts/table-advanced.js"></script>



    <script type="text/javascript" src="../assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/clockface/js/clockface.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/bootstrap-daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.js"></script>
    <script type="text/javascript" src="../assets/global/plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js"></script>

    <script src="../assets/global/scripts/metronic.js" type="text/javascript"></script>
    <script src="../assets/admin/layout/scripts/layout.js" type="text/javascript"></script>
    <script src="../assets/admin/layout/scripts/quick-sidebar.js" type="text/javascript"></script>
    <script src="../assets/admin/layout/scripts/demo.js" type="text/javascript"></script>
    <script src="../assets/admin/pages/scripts/components-pickers.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#example').dataTable({
                "sPaginationType": "full_numbers",
                "iDisplayLength": 200
            });
        });

    </script>
    <script type="text/javascript">

        $(document).on("click","#approveme",function(){
            $("#a_record").empty();
            var idn = $(this).attr("name");

            $("#a_result").empty();
            $("#a_wait").css("display", "none");

            $.ajax({
                type: "POST",
                url: "fetchRefApprovalForm.php",
                data: {idn : idn},
                success:function(appr) {

                    $("#a_record").html(appr);

                }

            });
        });
        </script>
    <script type="text/javascript">

        $(document).on("click","#rejectme",function(){
            $("#r_record").empty();
            var idn = $(this).attr("name");

            $("#r_result").empty();
            $("#r_wait").css("display", "none");

            $.ajax({
                type: "POST",
                url: "fetchRefRejectForm.php",
                data: {idn : idn},
                success:function(rj) {

                    $("#r_record").html(rj);

                }

            });
        });
    </script>
    <script type="text/javascript">

        $(document).on("click","#viewm",function(){
            $("#v_record").empty();
            var idn = $(this).attr("name");

            $("#v_result").empty();
            $("#v_wait").css("display", "none");

            $.ajax({
                type: "POST",
                url: "fetchViewForm.php",
                data: {idn : idn},
                success:function(rj) {

                    $("#v_record").html(rj);

                }

            });
        });
    </script>

    <script>
        jQuery(document).ready(function() {
            Metronic.init(); // init metronic core componets
            Layout.init(); // init layout
            QuickSidebar.init(); // init quick sidebar
            Demo.init(); // init demo features
            Index.init();
            Index.initDashboardDaterange();
            //ComponentsPickers.init();
            //Index.initJQVMAP(); // init index page's custom scripts
            Index.initCalendar(); // init index page's custom scripts
            //ComponentsDropdowns.init();
            Tasks.initDashboardWidget();
            //TableAdvanced.init();

        });
    </script>
<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html>