<?php
require_once('mysql.class.php');
require_once('util.php');

class auth extends MySQL{
	
	var $homePage = "http://localhost/term/auth/dashboard.php";
	var $loginPage = "http://localhost/term/auth/signin.php";
	var $session = "";
	var $cookies = "";
	var $rememberMe = "";
	var $privateKey = "";//This is a secret key for encryption
	var $userId = "";
	var $userName = "";
	var $password = "";	
	var $adminEmail = "";
	
	
	private $user;
	private $output;
	
	function __construct(){
		parent::__construct();
		if (!isset($_SESSION)) {
		  session_start();
		}
	}
	
	function createUser(){
			$util = new util();
		
		if($this->userExist($_POST['username'])){
			return $util->generateAlert("username already exist","error");
		}
		
		$valuesArray['username'] = MySQL::SQLValue($_POST['username']);
		$valuesArray['password'] = MySQL::SQLValue(sha1('password'));
		$valuesArray['name'] = MySQL::SQLValue($_POST['name']);
		$valuesArray['phone'] = MySQL::SQLValue($_POST['phone']);
		$valuesArray['type'] = MySQL::SQLValue($_POST['type']);
		$valuesArray['count'] = MySQL::SQLValue(0, MySQL::SQLVALUE_NUMBER);
		$valuesArray['last_seen'] = MySQL::SQLValue(date('Y-m-d H:i:s'), MySQL::SQLVALUE_TIME);
		$valuesArray['attempts'] = MySQL::SQLValue(0, MySQL::SQLVALUE_NUMBER);	
		$valuesArray['connectionid'] = MySQL::SQLValue("");				
		$valuesArray['status'] = MySQL::SQLValue("Active");
		
		$sql = MySQL::BuildSQLInsert("users", $valuesArray);
		
		$this->TransactionBegin();
		$result = $this->Query($sql);
		
		if($result){ 
			$this->output = $util->generateAlert("Transaction Successful", "success");
			$this->TransactionEnd();
		}else{
			$this->output = $util->generateAlert("Transaction Failed".$this->Error(), "error");
			$this->TransactionRollback();
		}	
		
		return $this->output;
		
	}

	function createMenu(){
		$util = new util();
				
		$valuesArray['url'] = MySQL::SQLValue($_POST['url']);
		$valuesArray['link_text'] =  MySQL::SQLValue($_POST['link_text']);
		
		$sql = MySQL::BuildSQLInsert("menus", $valuesArray);
		
		$this->TransactionBegin();
		$result = $this->Query($sql);
		
		if($result){ 
			$this->message = $util->generateAlert("Transaction Successful", "success");
			$this->TransactionEnd();
		}else{
			$this->message = $util->generateAlert("Transaction Failed", "error");
			echo $this->Error();
			$this->TransactionRollback();
		}		
		
	}

	function createRoles(){
		$util = new util();
				
		$valuesArray['role'] = MySQL::SQLValue($_POST['role']);
		$valuesArray['level'] =  MySQL::SQLValue($_POST['level'], MySQL::SQLVALUE_NUMBER);
		
		$sql = MySQL::BuildSQLInsert("roles", $valuesArray);
		
		$this->TransactionBegin();
		$result = $this->Query($sql);
		
		if($result){ 
			$this->message = $util->generateAlert("Transaction Successful", "success");
			$this->TransactionEnd();
		}else{
			$this->message = $util->generateAlert("Transaction Failed\n".$this->Error(), "error");
			$this->TransactionRollback();
		}		
		
	}


	
	function userExist($username){
		if(!$this->validEmail($username)){
			//Invalid username, should be a valid email address
			//echo "Username should be a valid email";
		}
		$this->TransactionBegin();
		$username = MySQL::SQLValue($username, MySQL::SQLVALUE_TEXT);
		$sql = "SELECT * FROM users WHERE user_login = $username";
		$this->Query($sql);
		
		$result = $this->RowCount();
		if($result){
			$this->user = $this->Row();
			return true;	
		}else{			
			return false;			
		}	
	}	
	
	function login($username, $password){
		
		session_write_close();
		session_start();
		
		$user = "";
		$util = new util();
		
		$this->password = sha1($password);
		
		if(!$this->userExist($username)){		
			//User does not exist
			$this->output .= 
			$util->generateAlert("Sorry, the username you entered does not exist. 
			Please check and try again","error");
			return $this->output;			
		}

		$user = $this->user;

		if(!($this->password==$user->password)){
			//Password does not match
			$this->TransactionBegin();
			$attempts = $user->attempts;
			$valuesArray['attempts'] = ++$attempts;
			
			$whereArray['id'] = $user->id;
			
			$sql = MySQL::BuildSQLUpdate("users", $valuesArray, $whereArray);		
			$this->Query($sql);
			$this->TransactionEnd();
			
			$msg = "The password you enetered does not match. Please check and try again";
			$type = "error";
			
			$this->output .= $util->generateAlert($msg,$type);
			return $this->output;			
		}
		if($user->status != "Active"){
			//Issue with account, contact administrator	
		}
		
		$termLogin = hash("sha256", $this->privateKey.$this->userName.$this->password);
			
		//Set browser variables
		setcookie("termLogin", "$termLogin", time()+2592000, "/");
		setcookie("termRememberMe", "$username", time()+2592000, "/");
		$_SESSION['term_username'] = $user->username;
		$_SESSION['term_fullname'] = $user->name;
		$_SESSION['term_userid'] = $user->id;
		
		
		//Update user records
		$valuesArray['connectionid'] = MySQL::SQLValue($termLogin);
		$valuesArray['count'] = MySQL::SQLValue((++$user->count), MySQL::SQLVALUE_NUMBER);
		$valuesArray['attempts'] = MySQL::SQLValue(0, MySQL::SQLVALUE_NUMBER);
		
		$whereArray['id'] = MySQL::SQLValue($user->id, MYSQL::SQLVALUE_NUMBER);
		
		$tableName = 'usr_users';
		$sql = MySQL::BuildSQLUpdate($tableName,$valuesArray,$whereArray);
		
		$result = $this->Query($sql);
		
			if($result){ 
				$this->message = "ok";
				$this->TransactionEnd();
			}else{
				$this->message = $util->generateAlert("Authentication Failed, Click 
				<a href=\"../auth/signin.php\">HERE</a> to continue", "error");
				$this->TransactionRollback();
			}
			
		session_write_close();
		return $this->message;
	}
	
	function logout(){ 
	  
	  $this->TransactionBegin();
	  $tableName = "usr_users"; 
	  $valuesArray['connectionid'] = "" ;
	  $whereArray['username'] = $_COOKIE['termRememberMe'];
	  
	  $sql = MySQL::BuildSQLUpdate($tableName, $valuesArray, $whereArray);
	  $this->Query($sql);
	  $this->TransactionEnd();
	  
	  session_destroy();
	  setcookie("termLogin", "", time()-3600, "/");
	  setcookie("termRememberMe", "", time()-3600, "/");
	  $this->redirect($this->loginPage);
	  return true;
	}	
	
	function resetPassword($username){
		$newPassword = $this->generatePassword(10);
		$encrytedPassword = sha1($newPassword);

		$tableName = "usr_users";
		$valuesArray['user_pass'] = $encrytedPassword;
		$whereArray['user_login'] = $username;
		$sql = MySQL::BuildSQLUpdate($tableName,$valuesArray, $whereArray);
		$result = $this->Query($sql);
		return $result;
	}
	
	function forgetPassword($username){
		if($this->userExist($username)){
			$result = $this->resetPassword($username);
			return $result;	

		}		
	}
		
	function generatePassword($length) {
	  $str="";
	  $chars = "subinsblogabcdefghijklmanopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	  $size = strlen($chars);
	  for($i = 0;$i < $length;$i++) {
	   $str .= $chars[rand(0,$size-1)];
	  }
	  return $str;
	}
	
	function validEmail($username){
		 return !preg_match('/^[a-zA-Z0-9]+[a-zA-Z0-9_.-]+[a-zA-Z0-9_-]+
		 @[a-zA-Z0-9]+[a-zA-Z0-9.-]+[a-zA-Z0-9]+.[a-z]{2,4}$/', 
		 $username) ? false:true;
	}
	
	function redirect($location){
		header("Location: $location");
	}
	
	function changePassword($username, $opassword, $npassword, $cpassword){
		
		$util = new util();	
		

		if(!($npassword==$cpassword)){
			return '<div class="alert-danger">The new password does not match the 
			confirmation provided </div>';exit;
		}

		if($npassword===$opassword){
			return'<div class="alert-danger">Sorry, Your new password should be 
			different from your current one</div>';exit;
		}
		
								
		$this->TransactionBegin();
		$tablename = "stud_main";
		$valuesArray['password'] = 	MySQL::SQLValue(sha1($npassword));	 
		$whereArray['reg_number'] = MySQL::SQLValue($username);
		$sql = MySQL::BuildSQLSelect($tablename, $whereArray);	
		$this->Query($sql);
		$user = $this->Row();
		if(!is_object($user)){
			return ('<div class="alert-danger">User details not found, please contact 
			the administrator </div>');exit;	 
		}
		
		if(sha1($opassword)==$user->password){
			$this->Query(MySQL::BuildSQLUpdate($tablename, $valuesArray, 
			$whereArray));
			$this->TransactionEnd();
			return '<div class="alert-success">Password Changed Successfully</div>'
			;exit();							
		}else{
			return '<div class="alert-danger">The old password you entered was 
			incorrect</div>';	exit();		
		}
	}
	
	
}//End of auth class


$user = new auth();
$response = "";

if(isset($_POST['submit']) && $_POST['submit']=="insertUser"){
echo $user->createUser();exit;
}

if(isset($_POST['submit']) && $_POST['submit']=="changePassword"){
$username = $_SESSION['sip_reg'];
$opassword =  $_POST['opassword'];
$npassword =  $_POST['npassword'];
$cpassword =  $_POST['cpassword'];

echo $user->changePassword($username, $opassword, $npassword, $cpassword);exit;
}