<?php

class util{
	
	function generateAlert($msg, $type="info"){
		$msg = strtoupper($msg);
		return "<div class=\"alert alert-$type hidden-tablet\"><i class=\"icon-lightbulb pull-left\"></i> $msg</div>";		
	}
	
	function sendMail($message=NULL,$to=NULL,$from=NULL,$subject=NULL) {		
		$eol="\n";
		# Common Headers
		$adminEmail = $this->adminEmail;
		$headers  = 'From: System Administrator <'.$adminEmail.'>'.$eol;
		$headers .= 'Reply-To: System Administrator <'.$adminEmail.'>'.$eol;
		$headers .= 'Return-Path: System Administrator <'.$adminEmail.'>'.$eol;    // these two to set reply address
		$headers .= "Message-ID: <".date("Y-m-d H:i:s")." TERM@".$_SERVER['SERVER_NAME'].">".$eol;
		$headers .= "X-Mailer: PHP v".phpversion().$eol; // These two to help avoid spam-filters
		$headers .= 'MIME-Version: 1.0'.$eol;
		$headers .= "Content-type: text/html; charset=ISO-8859-1\n";
		ini_set('sendmail_from',$adminEmail);  // the INI lines are to force the From
		
		mail($to,$subject,$message,$headers);
		ini_restore('sendmail_from');
	}
	
		public function process($args=array())	{
			
		$this->args 	=	array(
			'file'				=>	'file',
			'upload_path'		=>	'uploads/',
			'allowed_formats'	=>	array( 'jpg', 'png' ),
			'allowed_size'		=>	1024 * 1024
		);

		$this->args = array_merge( $this->args, $args );

		if( isset( $_POST ) and $_SERVER['REQUEST_METHOD'] == 'POST' )	{

			$name		=	$_FILES[ $this->args['file'] ]['name'];
			$type		=	$_FILES[ $this->args['file'] ]['type'];
			$tmp_name	=	$_FILES[ $this->args['file'] ]['tmp_name'];
			$error		=	$_FILES[ $this->args['file'] ]['error'];
			$size		=	$_FILES[ $this->args['file'] ]['size'];

			if( strlen( $name ) == 0 )	{
				echo 'Please select image...';
				exit;
			}

			list( $filename, $ext )	=	explode('.', $name);
			if( ! in_array( $ext, $this->args['allowed_formats'] ) )	{
				echo 'Invalid file format';
				exit;
			}

			if( $size > $this->args['allowed_size'] )	{
				echo 'Invalid file size';
				exit;
			}

			if( ! is_dir( $this->args['upload_path'] ) )	{
				echo 'Upload directory not exist';
				exit;
			}

			if( ! move_uploaded_file( $tmp_name, $this->args['upload_path'] . $name ) )	{
				echo 'File upload failed';
				exit;	
			}

			echo "<img src='".$this->args['upload_path'] . $name."'  class='preview'>";
			exit;
		}
		
	}		
	
}